<?php

function sendJointAccountInvitation($invitee_email, $invitee_name, $inviter_name, $invitation_token, $account_type, $permissions) {
    $subject = "Joint Account Invitation - Rhinovest";
    
    $permissions_text = implode(', ', $permissions);
    $accept_url = "https://rhinovest.group/dashboard/joint-accounts/accept?token=" . $invitation_token;
    
    $message = "
    <html>
    <head>
        <title>Joint Account Invitation</title>
    </head>
    <body style='font-family: Arial, sans-serif; line-height: 1.6; color: #333;'>
        <div style='max-width: 600px; margin: 0 auto; padding: 20px;'>
            <div style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0;'>
                <h1 style='margin: 0; font-size: 28px;'>Joint Account Invitation</h1>
                <p style='margin: 10px 0 0 0; font-size: 16px; opacity: 0.9;'>Rhinovest</p>
            </div>
            
            <div style='background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px;'>
                <h2 style='color: #333; margin-top: 0;'>Hello {$invitee_name},</h2>
                
                <p><strong>{$inviter_name}</strong> has invited you to join a joint account on Rhinovest.</p>
                
                <div style='background: white; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #667eea;'>
                    <h3 style='margin-top: 0; color: #667eea;'>Account Details:</h3>
                    <ul style='margin: 10px 0; padding-left: 20px;'>
                        <li><strong>Account Type:</strong> " . ucfirst($account_type) . "</li>
                        <li><strong>Your Permissions:</strong> {$permissions_text}</li>
                        <li><strong>Invitation Expires:</strong> " . date('F j, Y', strtotime('+7 days')) . "</li>
                    </ul>
                </div>
                
                <p>With a joint account, you can:</p>
                <ul style='margin: 10px 0; padding-left: 20px;'>
                    <li>Trade cryptocurrencies together</li>
                    <li>Share investment strategies</li>
                    <li>Monitor portfolio performance</li>
                    <li>Manage funds collaboratively</li>
                </ul>
                
                <div style='text-align: center; margin: 30px 0;'>
                    <a href='{$accept_url}' style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 15px 30px; text-decoration: none; border-radius: 25px; display: inline-block; font-weight: bold; font-size: 16px;'>
                        Accept Invitation
                    </a>
                </div>
                
                <p style='font-size: 14px; color: #666;'>
                    <strong>Important:</strong> This invitation will expire in 7 days. If you don't have an account yet, 
                    you'll be prompted to create one when you accept the invitation.
                </p>
                
                <hr style='border: none; border-top: 1px solid #eee; margin: 30px 0;'>
                
                <p style='font-size: 12px; color: #999; text-align: center;'>
                    If you didn't expect this invitation or have any questions, please contact our support team.
                    <br><br>
                    © 2025 Rhinovest. All rights reserved.
                </p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    // Email headers
    $headers = array(
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=UTF-8',
        'From: Rhinovest <noreply@hybidsupport.net>',
        'Reply-To: support@hybidsupport.net',
        'X-Mailer: PHP/' . phpversion()
    );
    
    // Send email
    $result = mail($invitee_email, $subject, $message, implode("\r\n", $headers));
    
    return $result;
}

function sendJointAccountAcceptanceNotification($inviter_email, $inviter_name, $invitee_name, $account_id) {
    $subject = "Joint Account Accepted - Rhinovest";
    
    $message = "
    <html>
    <head>
        <title>Joint Account Accepted</title>
    </head>
    <body style='font-family: Arial, sans-serif; line-height: 1.6; color: #333;'>
        <div style='max-width: 600px; margin: 0 auto; padding: 20px;'>
            <div style='background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0;'>
                <h1 style='margin: 0; font-size: 28px;'>Joint Account Accepted!</h1>
                <p style='margin: 10px 0 0 0; font-size: 16px; opacity: 0.9;'>Rhinovest</p>
            </div>
            
            <div style='background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px;'>
                <h2 style='color: #333; margin-top: 0;'>Hello {$inviter_name},</h2>
                
                <p>Great news! <strong>{$invitee_name}</strong> has accepted your joint account invitation.</p>
                
                <div style='background: white; padding: 20px; border-radius: 8px; margin: 20px 0; border-left: 4px solid #28a745;'>
                    <h3 style='margin-top: 0; color: #28a745;'>Account Details:</h3>
                    <ul style='margin: 10px 0; padding-left: 20px;'>
                        <li><strong>Account ID:</strong> #{$account_id}</li>
                        <li><strong>Status:</strong> Active</li>
                        <li><strong>Members:</strong> {$inviter_name} & {$invitee_name}</li>
                    </ul>
                </div>
                
                <p>Your joint account is now ready for trading! You can:</p>
                <ul style='margin: 10px 0; padding-left: 20px;'>
                    <li>Start trading cryptocurrencies together</li>
                    <li>Monitor your shared portfolio</li>
                    <li>Manage joint transactions</li>
                    <li>View account activity and history</li>
                </ul>
                
                <div style='text-align: center; margin: 30px 0;'>
                    <a href='https://rhinovest.group/dashboard/joint-accounts' style='background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 15px 30px; text-decoration: none; border-radius: 25px; display: inline-block; font-weight: bold; font-size: 16px;'>
                        View Joint Account
                    </a>
                </div>
                
                <hr style='border: none; border-top: 1px solid #eee; margin: 30px 0;'>
                
                <p style='font-size: 12px; color: #999; text-align: center;'>
                    If you have any questions about your joint account, please contact our support team.
                    <br><br>
                    © 2024 Rhinovest. All rights reserved.
                </p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    // Email headers
    $headers = array(
        'MIME-Version: 1.0',
        'Content-type: text/html; charset=UTF-8',
        'From: Rhinovest <noreply@hybidsupport.net>',
        'Reply-To: support@hybidsupport.net',
        'X-Mailer: PHP/' . phpversion()
    );
    
    // Send email
    $result = mail($inviter_email, $subject, $message, implode("\r\n", $headers));
    
    return $result;
}
