<?php
require_once __DIR__ . '/../vendor/autoload.php';

// Manually set required JWT environment variables for the backend (for direct use in JWT functions)
// (No longer using $_ENV for payload values)

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

function create_jwt($user) {
    $now = time();
    $payload = [
        'iss' => $_ENV['JWT_ISSUER'] ?? 'rhinovest-app',
        'iat' => $now,
        'exp' => $now + (int)($_ENV['JWT_EXPIRE'] ?? 3600),
        'sub' => $user['id'],
        'role' => $user['role']
    ];
    return JWT::encode($payload, $_ENV['JWT_SECRET'], 'HS256');
}

function verify_jwt($token) {
    try {
        $decoded = JWT::decode($token, new Key($_ENV['JWT_SECRET'], 'HS256'));
        return (array)$decoded;
    } catch (Exception $e) {
        return false;
    }
}

function extract_jwt_from_headers($headers) {
    if (!isset($headers['Authorization'])) {
        return false;
    }
    return str_replace('Bearer ', '', $headers['Authorization']);
}

function verify_jwt_from_headers($headers) {
    $token = extract_jwt_from_headers($headers);
    if (!$token) {
        return false;
    }
    return verify_jwt($token);
} 