CREATE TABLE IF NOT EXISTS `investment_opportunities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `type` enum('real_estate','stock','etf','crypto') NOT NULL,
  `description` text,
  `expected_return_percentage` decimal(5,2) NOT NULL,
  `min_investment` decimal(15,2) NOT NULL DEFAULT 0.00,
  `risk_level` enum('low','medium','high') DEFAULT 'medium',
  `image_url` varchar(255) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `status` enum('active','inactive') DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `investment_opportunities` (`title`, `type`, `description`, `expected_return_percentage`, `min_investment`, `risk_level`, `image_url`, `details`) VALUES
('Luxury Downtown Apartment Complex', 'real_estate', 'Invest in a premium residential complex in the heart of the city. High rental yield and appreciation potential.', 12.50, 5000.00, 'low', 'https://images.unsplash.com/photo-1545324418-cc1a3fa10c00?w=800&q=80', 'Located in the prime financial district, this complex offers 200 units with 95% occupancy. Investors receive quarterly dividends from rental income.'),
('Tech Growth Fund (ETF)', 'etf', 'A diversified portfolio of top-performing technology stocks including AI and cloud computing leaders.', 15.20, 1000.00, 'medium', 'https://images.unsplash.com/photo-1611974765270-ca12586343bb?w=800&q=80', 'This ETF tracks the NASDAQ-100 with a focus on emerging AI technologies. Managed by top-tier algorithms for maximum growth.'),
('Green Energy Infrastructure', 'stock', 'Support sustainable energy projects with stable government-backed returns.', 9.80, 2500.00, 'low', 'https://images.unsplash.com/photo-1466611653911-95081537e5b7?w=800&q=80', 'Invests in solar farms and wind turbines across Europe. guaranteed feed-in tariffs provide stable, long-term returns.'),
('Commercial Real Estate REIT', 'real_estate', 'Exposure to high-value commercial properties across major metropolitan areas.', 10.50, 1000.00, 'medium', 'https://images.unsplash.com/photo-1486406146926-c627a92ad1ab?w=800&q=80', 'A curated collection of Grade A office spaces and logistics hubs. Resilient to market volatility with long-term corporate leases.');
