-- Update users table to ensure all necessary columns exist for admin functionality
ALTER TABLE users 
ADD COLUMN IF NOT EXISTS status ENUM('active', 'suspended', 'pending', 'deleted') DEFAULT 'active',
ADD COLUMN IF NOT EXISTS last_login TIMESTAMP NULL,
ADD COLUMN IF NOT EXISTS deleted_at TIMESTAMP NULL,
ADD COLUMN IF NOT EXISTS role ENUM('user', 'manager', 'admin') DEFAULT 'user';

-- Add indexes for better performance
ALTER TABLE users 
ADD INDEX IF NOT EXISTS idx_status (status),
ADD INDEX IF NOT EXISTS idx_role (role),
ADD INDEX IF NOT EXISTS idx_created_at (created_at);

-- Ensure at least one admin user exists
INSERT IGNORE INTO users (name, email, username, password, role, status, created_at) 
VALUES ('Admin User', 'admin@example.com', 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'active', NOW());
