-- Populate payment_methods table with default payment methods
-- This ensures users have access to working payment methods with proper details

-- First, clear existing data to avoid duplicates
DELETE FROM payment_methods;

-- Insert default payment methods with complete account details and instructions
INSERT INTO payment_methods (
    name, 
    type, 
    description, 
    instructions, 
    account_details, 
    is_active, 
    is_default, 
    min_amount, 
    max_amount, 
    processing_time, 
    fees
) VALUES 
(
    'Wire Transfer',
    'wire_transfer',
    'International bank wire transfers via SWIFT',
    'Please include your username as reference when making the transfer. This ensures your deposit is credited to the correct account.',
    JSON_OBJECT(
        'bank_name', 'Bank of America',
        'account_number', '1234567890',
        'routing_number', '021000021',
        'account_holder', 'Wealth Crypto Nexus LLC',
        'swift_code', 'BOFAUS3N',
        'bank_address', '100 Bank of America Plaza, Charlotte, NC 28255'
    ),
    TRUE,
    TRUE,
    100.00,
    100000.00,
    '1-3 business days',
    '$15-25'
),
(
    'SEPA Transfer',
    'sepa',
    'European SEPA bank transfers',
    'Use your username as the payment reference. SEPA transfers are typically free and processed within 1 business day.',
    JSON_OBJECT(
        'bank_name', 'Deutsche Bank',
        'iban', 'DE89370400440532013000',
        'bic', 'COBADEFFXXX',
        'account_holder', 'Wealth Crypto Nexus GmbH',
        'bank_address', 'Taunusanlage 12, 60325 Frankfurt am Main, Germany'
    ),
    TRUE,
    FALSE,
    10.00,
    50000.00,
    '1 business day',
    'Free'
),
(
    'Cryptocurrency',
    'cryptocurrency',
    'Bitcoin, Ethereum, USDC payments',
    'Send the exact amount to the wallet address below. Include your username in the memo/note field for proper credit.',
    JSON_OBJECT(
        'wallet_address', 'bc1qxy2kgdygjrsqtzq2n0yrf2493p83kkfjhx0wlh',
        'network', 'Bitcoin',
        'supported_coins', 'BTC, ETH, USDC, USDT',
        'qr_code_available', true
    ),
    TRUE,
    FALSE,
    10.00,
    100000.00,
    '10-60 minutes',
    'Network fees only'
),
(
    'Bank Account Transfer',
    'bank_account',
    'Direct bank account transfers',
    'Transfer funds directly to our business account. Use your username as the payment reference.',
    JSON_OBJECT(
        'bank_name', 'Chase Bank',
        'account_number', '0987654321',
        'routing_number', '021000021',
        'account_holder', 'Wealth Crypto Nexus LLC',
        'account_type', 'Business Checking',
        'bank_address', '270 Park Avenue, New York, NY 10017'
    ),
    TRUE,
    FALSE,
    50.00,
    50000.00,
    '1-2 business days',
    '$10-15'
),
(
    'Cash App',
    'cash_app',
    'Cash App instant transfers',
    'Send payment to our Cash App account. Include your username in the note field for proper credit.',
    JSON_OBJECT(
        'cash_app_id', '$WealthCryptoNexus',
        'account_holder', 'Wealth Crypto Nexus LLC',
        'supported_currencies', 'USD only',
        'instant_transfer', true
    ),
    TRUE,
    FALSE,
    1.00,
    10000.00,
    'Instant',
    'Free for standard transfers'
),
(
    'Venmo',
    'venmo',
    'Venmo peer-to-peer payments',
    'Send payment to our Venmo account. Include your username in the note field for proper credit.',
    JSON_OBJECT(
        'venmo_id', '@WealthCryptoNexus',
        'account_holder', 'Wealth Crypto Nexus LLC',
        'supported_currencies', 'USD only',
        'instant_transfer', true
    ),
    TRUE,
    FALSE,
    1.00,
    10000.00,
    'Instant',
    'Free for standard transfers'
),
(
    'PayPal',
    'paypal',
    'PayPal business payments',
    'Send payment to our PayPal business account. Include your username in the note field for proper credit.',
    JSON_OBJECT(
        'paypal_email', 'payments@wealthcryptonexus.com',
        'account_holder', 'Wealth Crypto Nexus LLC',
        'supported_currencies', 'USD, EUR, GBP',
        'business_verified', true
    ),
    TRUE,
    FALSE,
    5.00,
    25000.00,
    'Instant to 1 business day',
    '2.9% + $0.30'
);

-- Verify the data was inserted correctly
SELECT 
    name, 
    type, 
    is_default, 
    is_active, 
    JSON_EXTRACT(account_details, '$.bank_name') as bank_name,
    JSON_EXTRACT(account_details, '$.account_number') as account_number,
    JSON_EXTRACT(account_details, '$.wallet_address') as wallet_address
FROM payment_methods 
ORDER BY is_default DESC, name ASC;
