-- Create user_activity table for admin dashboard metrics
CREATE TABLE IF NOT EXISTS user_activity (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    activity_type VARCHAR(50) NOT NULL,
    description TEXT,
    ip_address VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_created_at (created_at),
    INDEX idx_activity_type (activity_type)
);

-- Add some sample data for testing
INSERT INTO user_activity (user_id, activity_type, description, ip_address) 
SELECT id, 'login', 'User login', '127.0.0.1' 
FROM users 
WHERE status = 'active' 
LIMIT 10;
