-- Create basic payments table for PaymentController compatibility
CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    currency VARCHAR(10) DEFAULT 'USD',
    method VARCHAR(50) NOT NULL,
    status ENUM('pending', 'completed', 'failed', 'refunded') DEFAULT 'pending',
    reference VARCHAR(100),
    type ENUM('deposit', 'withdrawal') NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_status (status),
    INDEX idx_type (type),
    INDEX idx_created_at (created_at)
);

-- Insert sample payment data for testing
INSERT INTO payments (user_id, amount, currency, method, status, reference, type) VALUES
(1, 1000.00, 'USD', 'wire_transfer', 'completed', 'WTX001', 'deposit'),
(1, 500.00, 'USD', 'crypto', 'pending', 'CRY002', 'deposit'),
(1, 200.00, 'USD', 'wire_transfer', 'completed', 'WTX003', 'withdrawal');
