-- Add trading-related columns to joint_account_transactions table
ALTER TABLE joint_account_transactions 
ADD COLUMN symbol VARCHAR(20) NULL AFTER type,
ADD COLUMN quantity DECIMAL(15,8) NULL AFTER symbol,
ADD COLUMN price DECIMAL(15,8) NULL AFTER quantity,
ADD COLUMN side ENUM('buy', 'sell') NULL AFTER price,
ADD COLUMN order_type ENUM('market', 'limit', 'stop') DEFAULT 'market' AFTER side,
ADD COLUMN avg_price DECIMAL(15,8) NULL AFTER order_type;

-- Add index for better performance on trading queries
CREATE INDEX idx_joint_transactions_symbol ON joint_account_transactions(symbol);
CREATE INDEX idx_joint_transactions_type_symbol ON joint_account_transactions(type, symbol);
CREATE INDEX idx_joint_transactions_side ON joint_account_transactions(side);

-- Add trading permissions to user_settings if not exists
INSERT IGNORE INTO user_settings (user_id, setting_key, setting_value) VALUES 
(1, 'joint_account_trading_enabled', 'true'),
(1, 'joint_account_trading_permissions', '["view", "trade", "withdraw"]');
