-- Create table to store per-user demo transaction restrictions set by managers
CREATE TABLE IF NOT EXISTS user_restrictions (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  manager_id INT NULL,
  demo_paused TINYINT(1) NOT NULL DEFAULT 0,
  reason VARCHAR(255) NULL,
  expires_at DATETIME NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  INDEX idx_user (user_id),
  INDEX idx_manager (manager_id),
  CONSTRAINT fk_user_restr_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT fk_user_restr_manager FOREIGN KEY (manager_id) REFERENCES managers(id) ON DELETE SET NULL
);
