-- Add copy trading fields to managers table
ALTER TABLE managers ADD COLUMN trading_specialties TEXT DEFAULT NULL;
ALTER TABLE managers ADD COLUMN trading_style VARCHAR(50) DEFAULT NULL;
ALTER TABLE managers ADD COLUMN risk_tolerance VARCHAR(20) DEFAULT NULL;
ALTER TABLE managers ADD COLUMN years_forex VARCHAR(10) DEFAULT NULL;
ALTER TABLE managers ADD COLUMN years_crypto VARCHAR(10) DEFAULT NULL;
ALTER TABLE managers ADD COLUMN years_stocks VARCHAR(10) DEFAULT NULL;
ALTER TABLE managers ADD COLUMN preferred_session VARCHAR(20) DEFAULT NULL;
ALTER TABLE managers ADD COLUMN max_drawdown VARCHAR(10) DEFAULT NULL;

-- Add manager permission fields
ALTER TABLE managers ADD COLUMN allow_withdrawals BOOLEAN DEFAULT TRUE;
ALTER TABLE managers ADD COLUMN allow_cancellations BOOLEAN DEFAULT TRUE;
ALTER TABLE managers ADD COLUMN withdrawal_message TEXT DEFAULT NULL;
ALTER TABLE managers ADD COLUMN cancellation_message TEXT DEFAULT NULL;

-- Add investment type fields to investments table
ALTER TABLE investments ADD COLUMN trading_type VARCHAR(20) DEFAULT NULL;
ALTER TABLE investments ADD COLUMN trading_pairs TEXT DEFAULT NULL;
ALTER TABLE investments ADD COLUMN risk_level VARCHAR(20) DEFAULT NULL;

-- Add demo account tracking to users table
ALTER TABLE users ADD COLUMN demo_created_at TIMESTAMP DEFAULT NULL;
ALTER TABLE users ADD COLUMN demo_notified BOOLEAN DEFAULT FALSE;

-- Create investment campaigns table
CREATE TABLE IF NOT EXISTS investment_campaigns (
    id INT AUTO_INCREMENT PRIMARY KEY,
    manager_id INT NOT NULL,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    min_amount DECIMAL(15,2) NOT NULL,
    max_amount DECIMAL(15,2) DEFAULT NULL,
    target_amount DECIMAL(15,2) DEFAULT NULL,
    current_amount DECIMAL(15,2) DEFAULT 0,
    trading_type VARCHAR(20) DEFAULT NULL,
    trading_pairs TEXT DEFAULT NULL,
    risk_level VARCHAR(20) DEFAULT NULL,
    status ENUM('active', 'paused', 'completed', 'cancelled') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (manager_id) REFERENCES managers(id) ON DELETE CASCADE
);

-- Create withdrawal requests table
CREATE TABLE IF NOT EXISTS withdrawal_requests (
    id INT AUTO_INCREMENT PRIMARY KEY,
    investment_id INT NOT NULL,
    user_id INT NOT NULL,
    manager_id INT NOT NULL,
    amount DECIMAL(15,2) NOT NULL,
    status ENUM('pending', 'approved', 'rejected', 'processed') DEFAULT 'pending',
    reason TEXT DEFAULT NULL,
    requested_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    processed_at TIMESTAMP DEFAULT NULL,
    FOREIGN KEY (investment_id) REFERENCES investments(id) ON DELETE CASCADE,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (manager_id) REFERENCES managers(id) ON DELETE CASCADE
); 