<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE, PATCH');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../controllers/TransactionController.php';
require_once __DIR__ . '/../utils/jwt.php';

function handleTransactionRequest($method, $path, $input, $headers) {
    $transaction = new TransactionController();

    if (!isset($headers['Authorization'])) {
        return ['error' => 'Missing token', 'code' => 401];
    }
    $token = str_replace('Bearer ', '', $headers['Authorization']);
    $payload = verify_jwt($token);
    if (!$payload) {
        return ['error' => 'Invalid or expired token', 'code' => 401];
    }
    $user_id = $payload['sub'];

    if ($method === 'GET' && preg_match('#/api/transactions$#', $path)) {
        return ['transactions' => $transaction->getUserTransactions($user_id)];
    }

    if ($method === 'POST' && preg_match('#/api/transactions$#', $path)) {
        return $transaction->createTransaction($user_id, $input);
    }

    // Add update/delete routes as needed

    return ['error' => 'Not found', 'code' => 404];
} 