<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE, PATCH');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../controllers/SettingsController.php';
require_once __DIR__ . '/../utils/jwt.php';

function handleSettingsRequest($method, $path, $input, $headers) {
    $settings = new SettingsController();

    if (!isset($headers['Authorization'])) return ['error' => 'Missing token', 'code' => 401];
    $token = str_replace('Bearer ', '', $headers['Authorization']);
    $payload = verify_jwt($token);
    if (!$payload) return ['error' => 'Invalid or expired token', 'code' => 401];
    $user_id = $payload['sub'];

    if ($method === 'GET' && preg_match('#/api/settings$#', $path)) {
        return ['settings' => $settings->getUserSettings($user_id)];
    }
    if ($method === 'PUT' && preg_match('#/api/settings$#', $path)) {
        if (!isset($input['key'], $input['value'])) return ['error' => 'key and value required', 'code' => 400];
        return $settings->updateUserSetting($user_id, $input['key'], $input['value']);
    }
    return ['error' => 'Not found', 'code' => 404];
} 