<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE, PATCH');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../controllers/PaymentController.php';
require_once __DIR__ . '/../utils/jwt.php';

function handlePaymentRequest($method, $path, $input, $headers) {
    $payment = new PaymentController();

    if (!isset($headers['Authorization'])) return ['error' => 'Missing token', 'code' => 401];
    $token = str_replace('Bearer ', '', $headers['Authorization']);
    $payload = verify_jwt($token);
    if (!$payload) return ['error' => 'Invalid or expired token', 'code' => 401];
    $user_id = $payload['sub'];

    if ($method === 'GET' && preg_match('#/api/payments$#', $path)) {
        return ['payments' => $payment->getUserPayments($user_id)];
    }
    if ($method === 'POST' && preg_match('#/api/payments$#', $path)) {
        return $payment->createPayment($user_id, $input);
    }
    if ($method === 'PATCH' && preg_match('#/api/payments/(\d+)/status$#', $path, $matches)) {
        if (!isset($input['status'])) return ['error' => 'status required', 'code' => 400];
        return $payment->updatePaymentStatus($matches[1], $input['status']);
    }
    if ($method === 'GET' && preg_match('#/api/payments/status/(\w+)$#', $path, $matches)) {
        return ['payments' => $payment->getPaymentsByStatus($user_id, $matches[1])];
    }
    if ($method === 'POST' && preg_match('#/api/payments/(\d+)/refund$#', $path, $matches)) {
        return $payment->refundPayment($matches[1]);
    }
    if ($method === 'POST' && preg_match('#/api/payments/provider$#', $path)) {
        if (!isset($input['amount'], $input['method'])) return ['error' => 'amount and method required', 'code' => 400];
        return $payment->processWithProvider($user_id, $input['amount'], $input['method']);
    }
    if ($method === 'GET' && preg_match('#/api/payments/balance$#', $path)) {
        return $payment->getUserBalance($user_id);
    }
    if ($method === 'GET' && preg_match('#/api/user/balance$#', $path)) {
        return $payment->getUserBalances($user_id);
    }
    if ($method === 'POST' && preg_match('#/api/payments/balance/validate$#', $path)) {
        return $payment->validateUserBalances($user_id);
    }
    if ($method === 'POST' && preg_match('#/api/payments/balance/sync$#', $path)) {
        // Force sync balances for the user
        $balance = $payment->getUserBalance($user_id);
        return [
            'success' => true,
            'message' => 'Balances synchronized',
            'balance' => $balance['balance']
        ];
    }
    return ['error' => 'Not found', 'code' => 404];
} 