<?php
require_once __DIR__ . '/../controllers/MessageController.php';

function handleMessageRequest($method, $path, $user_id) {
    $controller = new MessageController();
    
    // GET /api/messages/{user_id} - Get messages between current user and another user
    if ($method === 'GET' && preg_match('#^/api/messages/(\d+)$#', $path, $matches)) {
        $other_user_id = intval($matches[1]);
        return $controller->getMessages($user_id, $other_user_id);
    }
    
    // POST /api/messages/send - Send a message
    if ($method === 'POST' && $path === '/api/messages/send') {
        $input = json_decode(file_get_contents('php://input'), true);
        
        if (!isset($input['receiver_id']) || !isset($input['message'])) {
            return ['error' => 'Missing required fields: receiver_id, message', 'code' => 400];
        }
        
        $receiver_id = intval($input['receiver_id']);
        $message = trim($input['message']);
        
        if (empty($message)) {
            return ['error' => 'Message cannot be empty', 'code' => 400];
        }
        
        return $controller->sendMessage($user_id, $receiver_id, $message);
    }
    
    // GET /api/messages/conversations - Get all conversations for current user
    if ($method === 'GET' && $path === '/api/messages/conversations') {
        return $controller->getConversations($user_id);
    }
    
    return ['error' => 'Method not allowed', 'code' => 405];
} 