<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE, PATCH');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once __DIR__ . '/../controllers/AuthController.php';
require_once __DIR__ . '/../utils/jwt.php';

function handleAuthRequest($method, $path, $input, $headers) {
    $auth = new AuthController();

    if ($method === 'POST' && preg_match('#/api/auth/register#', $path)) {
        return $auth->register($input);
    }

    if ($method === 'POST' && preg_match('#/api/auth/signup-with-invitation#', $path)) {
        return $auth->signupWithInvitation($input);
    }

    if ($method === 'POST' && preg_match('#/api/auth/login#', $path)) {
        if (!isset($input['email'], $input['password'])) {
            return ['error' => 'Email and password required', 'code' => 400];
        }
        return $auth->login(strtolower(trim($input['email'])), $input['password']);
    }

    if ($method === 'POST' && preg_match('#/api/auth/refresh#', $path)) {
        if (!isset($input['refresh_token'])) {
            return ['error' => 'Refresh token required', 'code' => 400];
        }
        return $auth->refresh($input['refresh_token']);
    }

    if ($method === 'POST' && preg_match('#/api/auth/logout#', $path)) {
        if (!isset($input['refresh_token'])) {
            return ['error' => 'Refresh token required', 'code' => 400];
        }
        return $auth->logout($input['refresh_token']);
    }

    if ($method === 'GET' && preg_match('#/api/user/profile#', $path)) {
        if (!isset($headers['Authorization'])) {
            return ['error' => 'Missing token', 'code' => 401];
        }
        $token = str_replace('Bearer ', '', $headers['Authorization']);
        $payload = verify_jwt($token);
        if (!$payload) {
            return ['error' => 'Invalid or expired token', 'code' => 401];
        }
        return $auth->getProfile($payload['sub']);
    }

    if ($method === 'GET' && preg_match('#/api/user/demo-status#', $path)) {
        if (!isset($headers['Authorization'])) {
            return ['error' => 'Missing token', 'code' => 401];
        }
        $token = str_replace('Bearer ', '', $headers['Authorization']);
        $payload = verify_jwt($token);
        if (!$payload) {
            return ['error' => 'Invalid or expired token', 'code' => 401];
        }
        return $auth->getDemoStatus($payload['sub']);
    }

    if ($method === 'PUT' && preg_match('#/api/user/demo-notified#', $path)) {
        if (!isset($headers['Authorization'])) {
            return ['error' => 'Missing token', 'code' => 401];
        }
        $token = str_replace('Bearer ', '', $headers['Authorization']);
        $payload = verify_jwt($token);
        if (!$payload) {
            return ['error' => 'Invalid or expired token', 'code' => 401];
        }
        return $auth->updateDemoNotified($payload['sub']);
    }

    if ($method === 'POST' && preg_match('#/api/investments/(\d+)/withdraw#', $path, $matches)) {
        if (!isset($headers['Authorization'])) {
            return ['error' => 'Missing token', 'code' => 401];
        }
        $token = str_replace('Bearer ', '', $headers['Authorization']);
        $payload = verify_jwt($token);
        if (!$payload) {
            return ['error' => 'Invalid or expired token', 'code' => 401];
        }
        $data = json_decode(file_get_contents('php://input'), true);
        return $auth->requestWithdrawal($payload['sub'], $matches[1], $data['amount']);
    }

    if ($method === 'POST' && preg_match('#/api/investments/(\d+)/cancel#', $path, $matches)) {
        if (!isset($headers['Authorization'])) {
            return ['error' => 'Missing token', 'code' => 401];
        }
        $token = str_replace('Bearer ', '', $headers['Authorization']);
        $payload = verify_jwt($token);
        if (!$payload) {
            return ['error' => 'Invalid or expired token', 'code' => 401];
        }
        return $auth->cancelInvestment($payload['sub'], $matches[1]);
    }

    return ['error' => 'Not found', 'code' => 404];
} 