<?php

require_once __DIR__ . '/../controllers/AutoInvestController.php';
require_once __DIR__ . '/../utils/jwt.php';

function handleAdminAutoInvest($method, $path, $input, $headers) {
    // Verify JWT
    if (!isset($headers['Authorization'])) {
        return ['error' => 'Missing token', 'code' => 401];
    }

    $token = str_replace('Bearer ', '', $headers['Authorization']);
    $payload = verify_jwt($token);

    if (!$payload) {
        return ['error' => 'Invalid or expired token', 'code' => 401];
    }

    // Verify admin role
    if (!isset($payload['role']) || $payload['role'] !== 'admin') {
        return ['error' => 'Admin access required', 'code' => 403];
    }

    $controller = new AutoInvestController();

    // GET /api/admin/auto-invest/plans - List all plans
    if ($method === 'GET' && preg_match('#^/api/admin/auto-invest/plans$#', $path)) {
        $controller->getAllPlans();
        exit;
    }

    // POST /api/admin/auto-invest/plans - Create plan
    if ($method === 'POST' && preg_match('#^/api/admin/auto-invest/plans$#', $path)) {
        $controller->createPlan();
        exit;
    }

    // PUT /api/admin/auto-invest/plans/{id} - Update plan
    if ($method === 'PUT' && preg_match('#^/api/admin/auto-invest/plans/(\d+)$#', $path, $matches)) {
        $controller->updatePlan($matches[1]);
        exit;
    }

    // DELETE /api/admin/auto-invest/plans/{id} - Delete plan
    if ($method === 'DELETE' && preg_match('#^/api/admin/auto-invest/plans/(\d+)$#', $path, $matches)) {
        $controller->deletePlan($matches[1]);
        exit;
    }

    return ['error' => 'Not found', 'code' => 404];
}
