<?php
/**
 * Database Diagnostic Script
 * Upload this to your production server and access it via browser
 * to check database connection and verify user exists
 */

// Load environment variables if .env exists
$envFile = __DIR__ . '/.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        list($name, $value) = explode('=', $line, 2);
        $_ENV[trim($name)] = trim($value);
    }
}

echo "<h1>Database Diagnostic Report</h1>";
echo "<pre>";

// 1. Check environment variables
echo "=== ENVIRONMENT VARIABLES ===\n";
echo "DB_CONNECTION: " . ($_ENV['DB_CONNECTION'] ?? 'not set (will use MySQL)') . "\n";
echo "DB_HOST: " . ($_ENV['DB_HOST'] ?? 'localhost (default)') . "\n";
echo "DB_DATABASE: " . ($_ENV['DB_DATABASE'] ?? 'wealth_nexus (default)') . "\n";
echo "DB_USERNAME: " . ($_ENV['DB_USERNAME'] ?? 'root (default)') . "\n";
echo "DB_PASSWORD: " . (isset($_ENV['DB_PASSWORD']) ? '***SET***' : 'empty (default)') . "\n\n";

// 2. Try to connect to database
echo "=== DATABASE CONNECTION TEST ===\n";
try {
    require_once __DIR__ . '/utils/db.php';
    $pdo = getPDO();
    echo "✓ Database connection successful!\n\n";
    
    // 3. Check if users table exists
    echo "=== CHECKING TABLES ===\n";
    $tables = $pdo->query("SHOW TABLES")->fetchAll(PDO::FETCH_COLUMN);
    echo "Tables found: " . count($tables) . "\n";
    foreach ($tables as $table) {
        echo "  - $table\n";
    }
    echo "\n";
    
    // 4. Check for specific user
    echo "=== CHECKING USER: billhooge@gmail.com ===\n";
    $stmt = $pdo->prepare("SELECT id, email, role, full_name, created_at FROM users WHERE email = ?");
    $stmt->execute(['billhooge@gmail.com']);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        echo "✓ User found!\n";
        echo "  ID: " . $user['id'] . "\n";
        echo "  Email: " . $user['email'] . "\n";
        echo "  Role: " . $user['role'] . "\n";
        echo "  Full Name: " . ($user['full_name'] ?? 'not set') . "\n";
        echo "  Created: " . $user['created_at'] . "\n";
    } else {
        echo "✗ User NOT found in database!\n";
        
        // List all users
        echo "\n=== ALL USERS IN DATABASE ===\n";
        $allUsers = $pdo->query("SELECT id, email, role FROM users LIMIT 10")->fetchAll(PDO::FETCH_ASSOC);
        echo "Total users: " . count($allUsers) . "\n";
        foreach ($allUsers as $u) {
            echo "  - ID: {$u['id']}, Email: {$u['email']}, Role: {$u['role']}\n";
        }
    }
    
} catch (PDOException $e) {
    echo "✗ Database connection failed!\n";
    echo "Error: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><strong>IMPORTANT:</strong> Delete this file after viewing the results for security!</p>";
?>
