<?php

require_once __DIR__ . '/../utils/db.php';

class WalletController {
    private $pdo;
    // Simple encryption key - in prod should be env variable
    private $encKey = 'secure_admin_key_123'; 

    public function __construct() {
        $this->pdo = getPDO();
    }

    // Generate Wallet (Called when user buys crypto first time or explicitly requests)
    public function generate() {
        $userId = $_POST['user_id'];
        $currency = $_POST['currency'] ?? 'BTC';

        // Check if exists
        $stmt = $this->pdo->prepare("SELECT * FROM wallets WHERE user_id = ? AND currency = ?");
        $stmt->execute([$userId, $currency]);
        if ($stmt->fetch()) {
             echo json_encode(['error' => 'Wallet already exists']);
             return;
        }

        // Simulate Generation
        $address = $this->mockAddress($currency);
        $privateKey = $this->mockPrivateKey();
        $encryptedKey = $this->encryptKey($privateKey);

        $stmt = $this->pdo->prepare("
            INSERT INTO wallets (user_id, currency, address, private_key)
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([$userId, $currency, $address, $encryptedKey]);

        echo json_encode([
            'success' => true,
            'address' => $address,
            'currency' => $currency
        ]);
    }

    // Admin Only: Get Private Key
    public function getPrivateKey() {
        $adminId = $_POST['admin_id']; // Verify admin role in real auth middleware
        $walletId = $_GET['id'];
        
        // Mock Admin Check
        // if (!isAdmin($adminId)) return error;

        $stmt = $this->pdo->prepare("SELECT private_key FROM wallets WHERE id = ?");
        $stmt->execute([$walletId]);
        $wallet = $stmt->fetch();

        if ($wallet) {
            echo json_encode(['private_key' => $this->decryptKey($wallet['private_key'])]);
        } else {
            echo json_encode(['error' => 'Wallet not found']);
        }
    }

    private function mockAddress($curr) {
        $prefix = ($curr == 'BTC') ? '1' : '0x';
        return $prefix . substr(md5(uniqid()), 0, 32);
    }

    private function mockPrivateKey() {
        return bin2hex(random_bytes(32));
    }

    private function encryptKey($key) {
        return openssl_encrypt($key, 'AES-128-ECB', $this->encKey);
    }

    private function decryptKey($enc) {
        return openssl_decrypt($enc, 'AES-128-ECB', $this->encKey);
    }
}
