<?php
require_once __DIR__ . '/../utils/db.php';

class SettingsController {
    private $pdo;
    public function __construct() { $this->pdo = getPDO(); }

    public function getUserSettings($user_id) {
        $stmt = $this->pdo->prepare('SELECT setting_key, setting_value FROM user_settings WHERE user_id = ?');
        $stmt->execute([$user_id]);
        return $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    }

    public function updateUserSetting($user_id, $key, $value) {
        $stmt = $this->pdo->prepare('INSERT INTO user_settings (user_id, setting_key, setting_value) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)');
        $stmt->execute([$user_id, $key, $value]);
        return ['success' => true];
    }
} 