<?php
/**
 * API Keys Configuration
 * 
 * To use real data from external APIs, you need to obtain API keys from the respective services.
 * 
 * 1. Alpha Vantage (for stocks and forex):
 *    - Visit: https://www.alphavantage.co/support/#api-key
 *    - Sign up for a free account
 *    - Get your API key
 *    - Replace 'demo' with your actual API key below
 * 
 * 2. CoinGecko (for cryptocurrency):
 *    - Visit: https://www.coingecko.com/en/api
 *    - Sign up for a free account (optional for basic usage)
 *    - Get your API key (optional for basic usage)
 *    - The free tier allows 10-50 calls per minute
 * 
 * 3. Alternative APIs you can use:
 *    - Yahoo Finance (free, no API key required)
 *    - IEX Cloud (free tier available)
 *    - Polygon.io (free tier available)
 *    - Twelve Data (free tier available)
 */

// Alpha Vantage API Key for stocks and forex data
// Get your free API key from: https://www.alphavantage.co/support/#api-key
define('ALPHA_VANTAGE_API_KEY', $_ENV['ALPHA_VANTAGE_API_KEY'] ?? 'demo');

// CoinGecko API Key for cryptocurrency data (optional for basic usage)
// Get your API key from: https://www.coingecko.com/en/api
define('COINGECKO_API_KEY', $_ENV['COINGECKO_API_KEY'] ?? '');

// API Configuration
define('API_TIMEOUT', 10); // Timeout in seconds for API calls
define('API_RATE_LIMIT_DELAY', 200000); // Delay in microseconds between API calls (0.2 seconds)

// Enable/disable real API calls (set to false to use fallback data only)
define('ENABLE_REAL_API_CALLS', true);

// Cache settings (in seconds)
define('API_CACHE_DURATION', 180); // 3 minutes cache for API responses
