<?php
require_once __DIR__ . '/../../router.php';
require_once __DIR__ . '/../../utils/db.php';
require_once __DIR__ . '/../../utils/jwt.php';

// Ensure user is admin
$user = validateJWT();
if (!$user || $user['role'] !== 'admin') {
    http_response_code(403);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$pdo = getPDO();
$method = $_SERVER['REQUEST_METHOD'];

// Handle GET: List all plans (including inactive?)
if ($method === 'GET') {
    $stmt = $pdo->query("SELECT * FROM special_plans ORDER BY id DESC");
    echo json_encode(['success' => true, 'plans' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
    exit;
}

// Handle POST: Create new plan
if ($method === 'POST') {
    $data = $_POST;
    // Basic validation
    if (empty($data['name']) || empty($data['roi_percentage']) || empty($data['duration_days'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Missing required fields']);
        exit;
    }

    $stmt = $pdo->prepare("INSERT INTO special_plans (name, description, min_amount, max_amount, roi_percentage, duration_days, risk_level, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([
        $data['name'],
        $data['description'] ?? '',
        $data['min_amount'] ?? 0,
        $data['max_amount'] ?? null,
        $data['roi_percentage'],
        $data['duration_days'],
        $data['risk_level'] ?? 'medium',
        'active'
    ]);

    echo json_encode(['success' => true, 'message' => 'Plan created']);
    exit;
}

// Handle DELETE or toggle status
if ($method === 'DELETE') {
    // For now, let's just delete by ID in query string
    $id = $_GET['id'] ?? null;
    if ($id) {
        $stmt = $pdo->prepare("DELETE FROM special_plans WHERE id = ?");
        $stmt->execute([$id]);
        echo json_encode(['success' => true]);
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'ID required']);
    }
    exit;
}
